using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.SharePoint;
using Microsoft.SharePoint.WebPartPages;

using Microsoft.SharePoint.WebControls;

namespace EasyTabParts
{
	/// <summary>
	/// Description of the toolpart. Override the GetToolParts method in your Web Part
	/// class to invoke this toolpart. To establish a reference to the Web Part 
	/// the user has selected, use the ParentToolPane.SelectedWebPart property.
	/// </summary>
	public class PageTabsToolPart : Microsoft.SharePoint.WebPartPages.ToolPart
	{
		
		/// <summary>
		/// Constructor for the class. A great place to set Set default values for
		/// additional base class properties here.
		/// <summary>

		public PageTabsToolPart()
		{
			this.Title = "Page Tab Settings";
		}

		#region ApplyChanges - Updates web part with tool part changes

		///	<summary>
		///	Called by the tool pane to apply property changes to the selected Web Part. 
		///	</summary>
		public override void ApplyChanges()
		{
			// First, get the web part
			PageTabs ptWebPart = this.ParentToolPane.SelectedWebPart as PageTabs;
			if (ptWebPart != null)
			{
				// Set each property based on the values in the toolpart
				// controls
				ptWebPart.DocumentLibrary = docLibSelector.SelectedValue;
				ptWebPart.SortColumn = sortColumnSelector.SelectedValue;
				ptWebPart.ShowHome = showHomeCheckBox.Checked;
				ptWebPart.ShowHomeTitle = homeTitleTextBox.Text;
				ptWebPart.QueryString = queryStringTextBox.Text;
				if (navStyleRBList.SelectedValue == "links")
				{
					ptWebPart.NavStyle = PageTabs.WPStyle.Links;
				}
				else
				{
					ptWebPart.NavStyle = PageTabs.WPStyle.Tabs;
				}
				if (navOrientationRBList.SelectedValue == "horizontal")
				{
					ptWebPart.NavOrientation = PageTabs.WPOrientation.Horizontal;
				}
				else
				{
					ptWebPart.NavOrientation = PageTabs.WPOrientation.Vertical;
				}
			}
			ptWebPart.TopBarPixels = topBarDropDownList.Pixels;
			ptWebPart.BottomBarPixels = bottomBarDropDownList.Pixels;
			ptWebPart.ShowAdminLink = showAdminCheckBox.Checked;
		}

		#endregion

		#region SyncChanges() - Updates tool part when web part has been updated
		/// <summary>
		///	If the ApplyChanges method succeeds, this method is called by the tool pane 
		///	to refresh the specified property values in the toolpart user interface.
		/// </summary>
		public override void SyncChanges()
		{
			// The web part promises not to change anything, so we
			// have nothing to do
		}

		#endregion

		#region CancelChanges() - Backs out any changes in webpart if tool part changes are cancelled

		/// <summary>
		///	Called by the tool pane if the user discards changes to the selected Web Part. 
		/// </summary>
		public override void CancelChanges()
		{
		}

		#endregion

		#region Tool Part Rendering

		// ToolPart Controls
		private Label selectorLabel;
		private DropDownList docLibSelector;
		private Label sortSelectorLabel;
		private DropDownList sortColumnSelector;
		private Label checkBoxPrefixLabel;
		private CheckBox showHomeCheckBox;
		private Label homeTitleLabel;
		private TextBox homeTitleTextBox;
		private Label styleLabel;
		private RadioButtonList navStyleRBList;
		private Label orientationLabel;
		private RadioButtonList navOrientationRBList;
		private Label queryStringLabel;
		private TextBox queryStringTextBox;

		private Table PixelsTable;
		private Label topBarLabel;
		private PixelDropDownList topBarDropDownList;
		private Label bottomBarLabel;
		private PixelDropDownList bottomBarDropDownList;

		private Label showAdminLabel;
		private CheckBox showAdminCheckBox;

		// CreateChildControls () - Creates all the controls which make up
		// the toolpart
		protected override void CreateChildControls()
		{
			base.CreateChildControls ();

			// Get the associated web part
			PageTabs ptWebPart = this.ParentToolPane.SelectedWebPart as PageTabs;

			if (ptWebPart != null)
			{
				// ** Set up document library drop-down **
				selectorLabel = new Label ();
				selectorLabel.Text = "<br>Document Library: ";
				this.Controls.Add (selectorLabel);

				docLibSelector = new DropDownList();
				SPWeb myWeb = SPControl.GetContextWeb (Context);
				SPList myPageDocLib = null;
				// Iterate through the document libraries in this site
				// and add each one to the drop-down list
				foreach (SPList list in myWeb.Lists)
				{
					if (list.BaseType == SPBaseType.DocumentLibrary)
					{
						// Suppress built-in document libraries such as
						// galleries - we test to see if they allow
						// deletion, since the built-in ones don't.
						// We don't hard-code the names of built in doc
						// libs because they are different in the language
						// packs.
						if (list.AllowDeletion)
						{
							// If here, it's a bona-fide doc lib and we
							// want to show it
							string docLibName = list.Title;
							ListItem li = new ListItem (docLibName, docLibName);
							docLibSelector.Items.Add (li);
							if (li.Value == ptWebPart.DocumentLibrary)
							{
								// If here, we have the doc lib the web
								// part was already connected to - select it
								li.Selected = true;
								myPageDocLib = myWeb.Lists [li.Value];
							}
						}
					}
				}
				// If we didn't find the doc library the web part expects,
				// then use the first one
				if (myPageDocLib == null && docLibSelector.Items.Count > 0)
				{
					docLibSelector.SelectedIndex = 0;
					myPageDocLib = myWeb.Lists [docLibSelector.SelectedValue];
				}
				// When the selector is changed, we need to repaint the sort
				// order selector. So - turn on postbacks and set up an
				// event handler
				docLibSelector.AutoPostBack = true;
				docLibSelector.SelectedIndexChanged += 
					new EventHandler(docLibSelector_SelectedIndexChanged);
				this.Controls.Add (docLibSelector);

				// ** Set up sort column drop-down **

				sortSelectorLabel = new Label();
				sortSelectorLabel.Text = "<br>Sort Column: ";
				this.Controls.Add (sortSelectorLabel);

				sortColumnSelector = new DropDownList();

				// If we have a valid doc library, grovel through the fields
				// and add them to the sort drop-down
				if (myPageDocLib != null)
				{
					foreach (SPField field in myPageDocLib.Fields)
					{
						if (!IsHiddenField (field))
						{
							// If here, we have a field we have deemed
							// worthy of showing. Add it to the list
							string fieldName = field.Title;
							string fieldInternalName = field.InternalName;
							ListItem li = new ListItem (fieldName, fieldInternalName);
							sortColumnSelector.Items.Add (li);
							if (li.Value == ptWebPart.SortColumn)
							{
								li.Selected = true;
							}
						}
					}
				}
				this.Controls.Add (sortColumnSelector);

				// ** Set up check box for "Show Home" **
				checkBoxPrefixLabel = new Label();
				checkBoxPrefixLabel.Text = "<br>";
				this.Controls.Add (checkBoxPrefixLabel);

				showHomeCheckBox = new CheckBox();
				showHomeCheckBox.Text = "Show Link to Main Page";
				showHomeCheckBox.Checked = ptWebPart.ShowHome;
				this.Controls.Add (showHomeCheckBox);

				// ** Set up text box for home page name **
				homeTitleLabel = new Label();
				homeTitleLabel.Text = "<br>Title for Main Page: ";
				this.Controls.Add (homeTitleLabel);

				homeTitleTextBox = new TextBox();
				homeTitleTextBox.Text = ptWebPart.ShowHomeTitle;
				this.Controls.Add (homeTitleTextBox);

				// ** Set up radio buttons for navigation style **
				styleLabel = new Label();
				styleLabel.Text = "Navigation Style";
				this.Controls.Add (styleLabel);

				navStyleRBList = new RadioButtonList();
				navStyleRBList.Items.Add (new ListItem ("Tabs", "tabs"));
				navStyleRBList.Items.Add (new ListItem ("Links", "links"));
				if (ptWebPart.NavStyle == PageTabs.WPStyle.Tabs)
				{
					navStyleRBList.SelectedIndex = 0;
				}
				else
				{
					navStyleRBList.SelectedIndex = 1;
				}
				this.Controls.Add (navStyleRBList);

				// ** Set up radio buttons for orientation **
				orientationLabel = new Label();
				orientationLabel.Text = "Orientation";
				this.Controls.Add (orientationLabel);

				navOrientationRBList = new RadioButtonList();
				navOrientationRBList.Items.Add (new ListItem ("Horizontal", "horizontal"));
				navOrientationRBList.Items.Add (new ListItem ("Vertical", "vertical"));
				if (ptWebPart.NavOrientation == PageTabs.WPOrientation.Horizontal)
				{
					navOrientationRBList.SelectedIndex = 0;
				}
				else
				{
					navOrientationRBList.SelectedIndex = 1;
				}
				this.Controls.Add (navOrientationRBList);

				// ** Set up text box for query string **
				queryStringLabel = new Label();
				queryStringLabel.Text = "Query String for Connected Data:<br>";
				this.Controls.Add (queryStringLabel);

				queryStringTextBox = new TextBox();
				queryStringTextBox.Text = ptWebPart.QueryString;
				this.Controls.Add (queryStringTextBox);

				// ** Set up top and bottom bar pixel controls **
				// Here we use a table so the drop-downs line up
				PixelsTable = new Table();

				//First, add a row for top bar pixels
				TableRow trow = new TableRow();
				TableCell tcell = new TableCell();
				topBarLabel = new Label ();
				topBarLabel.Text = "Top Bar Thickness:";
				tcell.Controls.Add (topBarLabel);
				trow.Cells.Add (tcell);
				tcell = new TableCell();
				topBarDropDownList = 
					new PixelDropDownList (ptWebPart.TopBarPixels);
				tcell.Controls.Add (topBarDropDownList);
				trow.Cells.Add (tcell);
				PixelsTable.Rows.Add (trow);

				// And another for selecting bottom bar pixels
				trow = new TableRow();
				tcell = new TableCell();
				bottomBarLabel = new Label();
				bottomBarLabel.Text = "Bottom Bar Thickness: ";
				tcell.Controls.Add (bottomBarLabel);
				trow.Cells.Add (tcell);
				tcell = new TableCell();
				bottomBarDropDownList = new PixelDropDownList (ptWebPart.BottomBarPixels);
				tcell.Controls.Add (bottomBarDropDownList);
				trow.Cells.Add (tcell);
				PixelsTable.Rows.Add (trow);
				
				this.Controls.Add (PixelsTable);

				// ** Set up Show add page checkbox **
				showAdminLabel = new Label();
				showAdminLabel.Text = "Show add page link to Admins:";
				this.Controls.Add (showAdminLabel);

				showAdminCheckBox = new CheckBox();
				showAdminCheckBox.Checked = ptWebPart.ShowAdminLink;
				this.Controls.Add (showAdminCheckBox);
			}
		}

		// Event handler for docLibSelector
		// Called when someone selects a new document library ...
		// clear out the sort column drop-down and populate it with the
		// new library's fields
		private void docLibSelector_SelectedIndexChanged(object sender, EventArgs e)
		{
			// Get the web part, and clear out the column selector
			PageTabs ptWebPart = 
				this.ParentToolPane.SelectedWebPart as PageTabs;
			sortColumnSelector.Items.Clear();

			// Now open the document library selected
			SPWeb myWeb = SPControl.GetContextWeb (Context);
			SPList myPageDocLib = myWeb.Lists[docLibSelector.SelectedValue];

			if (ptWebPart != null)
			{
				// Grovel through the fields and populate the sort order
				// drop-down
				foreach (SPField field in myPageDocLib.Fields)
				{
					if (!IsHiddenField (field))
					{
						string fieldName = field.Title;
						string fieldInternalName = field.InternalName;
						ListItem li = new ListItem (fieldName, fieldInternalName);
						sortColumnSelector.Items.Add (li);
						if (li.Value == ptWebPart.SortColumn)
						{
							li.Selected = true;
						}
					}
				}
			}
		}

		// IsHiddenField() - Returns true if the referenced field is a
		// built-in one that should be hidden from view
		bool IsHiddenField (SPField field)
		{
			// Note - we use the internal names so this will work with non-English language packs
			string [] hiddenFieldNames = {"Created", "Author", "Modified", "Editor", "_ModerationStatus", "_ModerationComments",
										  "FileRef", "FileDirRef", "File_x0020_Size",
						// Comment out this next line to reveal modification
						// and creation dates as sort fields. NOTE that only
						// editing the page with FrontPage will change the
						// modification date! The web parts you place there
						// using the web browser are just "content" :-)
										  "Last_x0020_Modified", "Created_x0020_Date", 
										  "FSObjType", "CheckedOutUserId", "FileLeafRef", "VirusStatus", "CheckedOutTitle",
										  "LinkCheckedOutTitle", "Modified_x0020_By", "Created_x0020_By", "owshiddenversion",
										  "File_x0020_Type", "HTML_x0020_File_x0020_Type", "_SourceUrl", "_SharedFileIndex", "EncodedAbsUrl",
										  "LinkFilenameNoMenu", "LinkFilename", "SelectTitle", "SelectFilename", "Edit",
										  "DocIcon", "ServerUrl", "EncodeAbsUrl", "Title", "FileSizeDisplay", "InstanceID",
										  "Order"};

			// We use the _internal_ field name since it isn't translated
			// in the language packs - the display name is!
			string fieldName = field.InternalName;

			// Search for our field name in the hiddenFieldNames array
			for (int i=hiddenFieldNames.GetLowerBound(0); i<=hiddenFieldNames.GetUpperBound(0); i++)
			{
				if (fieldName == hiddenFieldNames[i])
				{
					return (true);
				}
			}
			return (false);
		}

		/// <summary>
		/// Render this Tool part to the output parameter specified.
		/// </summary>
		/// <param name="output"> The HTML writer to write out to </param>
		//		protected override void RenderToolPart(HtmlTextWriter output)
		//		{
		//		}

		#endregion
	}											
}
								
